/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWWorkClassProxy;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.IVWDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.IVWEditorTool;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWAttachmentFieldDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWDataFieldDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionItem;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWFunctionConstants;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWFunctionDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWFunctionGroup;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWGuidFieldDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWPartnerLinkDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWStepResponseDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWWorkflowGroupDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWXMLDataFieldDescriptionPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class VWItemPicker
extends JPanel
implements IVWEditorTool,
ActionListener,
ListSelectionListener {
    protected static final int NONE = 0;
    protected static final int DATA_FIELDS = 1;
    protected static final int ATTACHMENT_FIELDS = 2;
    protected static final int WORKFLOW_GROUPS = 4;
    protected static final int FUNCTIONS = 8;
    protected static final int STEP_RESPONSES = 16;
    protected static final int WAITED_FOR_WORKFLOW_FIELDS = 32;
    protected static final int CREATE_WORKFLOW_FIELDS = 64;
    protected static final int SYSTEM_FIELDS = 128;
    protected static final int SCHEMA = 256;
    protected static final int XML_DATA_FIELDS = 512;
    protected static final int PARTNERLINKS = 1024;
    protected static final int GUID_FIELDS = 2048;
    protected static final int BASIC_ATTRIBUTES = 2703;
    protected static final int NORMAL = 0;
    protected static final int LEFT_VALUE = 1;
    protected static final int RIGHT_VALUE = 2;
    private static final VWFunctionGroup s_dataTypeConversionFunctions = new VWFunctionGroup(VWResource.s_dataTypeConversion, 1, VWFunctionConstants.DATA_TYPE_CONVERSION_FUNCTIONS);
    private static final VWFunctionGroup s_generalFunctions = new VWFunctionGroup(VWResource.s_general, 2, VWFunctionConstants.GENERAL_FUNCTIONS);
    private static final VWFunctionGroup s_messageExpansionFunctions = new VWFunctionGroup(VWResource.s_messageExpansion, 10, VWFunctionConstants.MSG_EXPANSION_FUNCTIONS);
    private static final VWFunctionGroup s_numericFunctions = new VWFunctionGroup(VWResource.s_numeric, 3, VWFunctionConstants.NUMERIC_FUNCTIONS);
    private static final VWFunctionGroup s_nullFunctions = new VWFunctionGroup(VWResource.s_null, 4, VWFunctionConstants.NULL_FUNCTIONS);
    private static final VWFunctionGroup s_stepResponseFunctions = new VWFunctionGroup(VWResource.s_stepResponse, 5, VWFunctionConstants.STEP_RESPONSE_FUNCTIONS);
    private static final VWFunctionGroup s_stringFunctions = new VWFunctionGroup(VWResource.s_string, 6, VWFunctionConstants.STRING_FUNCTIONS);
    private static final VWFunctionGroup s_systemInterrogationFunctions = new VWFunctionGroup(VWResource.s_systemInterrogation, 7, VWFunctionConstants.SYSTEM_INTERROGATION_FUNCTIONS);
    private static final VWFunctionGroup s_timeFunctions = new VWFunctionGroup(VWResource.s_time, 8, VWFunctionConstants.TIME_FUNCTIONS);
    private static final VWFunctionGroup s_xmlFunctions = new VWFunctionGroup(VWResource.s_xml, 9, VWFunctionConstants.XML_FUNCTIONS);
    private static final VWFunctionGroup s_arrayFunctions = new VWFunctionGroup(VWResource.s_array, 12, VWFunctionConstants.ARRAY_FUNCTIONS);
    private static final VWFunctionGroup s_xpathXsltFunctions = new VWFunctionGroup(VWResource.s_xpathXslt, 13, VWFunctionConstants.XPATH_XSLT_FUNCTIONS);
    private static final VWFunctionGroup s_attachmentTemplateFunctions = new VWFunctionGroup(VWResource.s_attachmentTemplate, 14, VWFunctionConstants.ATTACHMENT_TEMPLATE_FUNCTIONS);
    private JPanel m_itemPickerPanel = null;
    private JComboBox m_itemTypeComboBox = null;
    private JList m_itemList = null;
    private VWSortedListModel m_itemListModel = null;
    private JPanel m_descriptionPanel = null;
    private CardLayout m_cardLayout = null;
    private VWDataFieldDescriptionPanel m_dataFieldDescriptionPanel = null;
    private VWXMLDataFieldDescriptionPanel m_xmlDataFieldDescriptionPanel = null;
    private VWAttachmentFieldDescriptionPanel m_attachmentFieldDescriptionPanel = null;
    private VWGuidFieldDescriptionPanel m_guidFieldDescriptionPanel = null;
    private VWWorkflowGroupDescriptionPanel m_workflowGroupDescriptionPanel = null;
    private VWFunctionDescriptionPanel m_functionDescriptionPanel = null;
    private VWStepResponseDescriptionPanel m_stepResponseDescriptionPanel = null;
    private VWPartnerLinkDescriptionPanel m_partnerLinkDescriptionPanel = null;
    private GridBagConstraints m_gbCons = null;
    private JDialog m_parentDialog = null;
    private IVWPropertyData m_propertyData = null;
    private VWStepDefinition m_stepDefinition = null;
    private int m_itemTypes = 0;
    private IVWDescriptionPanel m_currentDescriptionPanel = null;
    private int m_orientation = 0;
    private VWWorkClassProxy m_workClassProxy = null;
    private int m_defaultItem = 0;
    private String m_defaultSubItem = null;

    public VWItemPicker(IVWPropertyData propertyData, VWStepDefinition stepDefinition, int itemTypes, int orientation) {
        this.m_propertyData = propertyData;
        this.m_stepDefinition = stepDefinition;
        this.m_itemTypes = itemTypes;
        this.m_orientation = orientation;
    }

    public VWItemPicker(JDialog parent, IVWPropertyData propertyData, VWStepDefinition stepDefinition, int itemTypes, int orientation) {
        this.m_parentDialog = parent;
        this.m_propertyData = propertyData;
        this.m_stepDefinition = stepDefinition;
        this.m_itemTypes = itemTypes;
        this.m_orientation = orientation;
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initItemPickerPanel();
        this.initDescriptionPanel();
        this.initItemTypeComboBox();
    }

    public void init(int defaultItem, String defaultSubItem, VWWorkClassProxy workClassProxy) {
        this.m_defaultItem = defaultItem;
        this.m_defaultSubItem = defaultSubItem;
        this.m_workClassProxy = workClassProxy;
        this.init();
    }

    public void setWorkClassProxy(VWWorkClassProxy workClassProxy) {
        this.m_workClassProxy = workClassProxy;
    }

    public String getCurrentExpressionItem() throws VWException {
        return this.m_currentDescriptionPanel.getExpressionItem();
    }

    public void setEnableControls(boolean enable) {
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_itemTypeComboBox) {
            this.performItemTypeAction();
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        Object src = event.getSource();
        if (src != null && src.equals(this.m_itemList)) {
            VWExpressionItem item = (VWExpressionItem)this.m_itemList.getSelectedValue();
            this.m_currentDescriptionPanel.setExpressionItem(item);
        }
    }

    private void initItemPickerPanel() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 0.3;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_itemPickerPanel = new JPanel();
        this.add((Component)this.m_itemPickerPanel, this.m_gbCons);
        this.m_itemPickerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_itemTypeComboBox = new JComboBox();
        this.m_itemTypeComboBox.setRenderer(new VWLabelListCellRenderer());
        this.m_itemTypeComboBox.addActionListener(this);
        this.m_itemPickerPanel.add((Component)this.m_itemTypeComboBox, gbCons);
        gbCons.fill = 1;
        ++gbCons.gridy;
        gbCons.weighty = 1.0;
        this.m_itemListModel = new VWSortedListModel();
        this.m_itemList = new JList(this.m_itemListModel);
        this.m_itemList.addListSelectionListener(this);
        this.m_itemPickerPanel.add((Component)new JScrollPane(this.m_itemList), gbCons);
    }

    private void initDescriptionPanel() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 1;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 0.7;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_cardLayout = new CardLayout();
        this.m_descriptionPanel = new JPanel(this.m_cardLayout);
        this.add((Component)this.m_descriptionPanel, this.m_gbCons);
        this.m_dataFieldDescriptionPanel = new VWDataFieldDescriptionPanel();
        this.m_dataFieldDescriptionPanel.init();
        this.m_descriptionPanel.add(VWResource.s_dataFieldDescription, this.m_dataFieldDescriptionPanel);
        this.m_xmlDataFieldDescriptionPanel = new VWXMLDataFieldDescriptionPanel(this.m_parentDialog, this.m_propertyData.getWorkflowDefinition());
        this.m_xmlDataFieldDescriptionPanel.init();
        this.m_descriptionPanel.add(VWResource.s_xmlDataFieldDescription, this.m_xmlDataFieldDescriptionPanel);
        this.m_attachmentFieldDescriptionPanel = new VWAttachmentFieldDescriptionPanel();
        this.m_attachmentFieldDescriptionPanel.init();
        this.m_descriptionPanel.add(VWResource.s_attachmentFieldDescription, this.m_attachmentFieldDescriptionPanel);
        this.m_guidFieldDescriptionPanel = new VWGuidFieldDescriptionPanel();
        this.m_guidFieldDescriptionPanel.init();
        this.m_descriptionPanel.add(VWResource.s_guidFieldDescription, this.m_guidFieldDescriptionPanel);
        this.m_workflowGroupDescriptionPanel = new VWWorkflowGroupDescriptionPanel();
        this.m_workflowGroupDescriptionPanel.init();
        this.m_descriptionPanel.add(VWResource.s_workflowGroupDescription, this.m_workflowGroupDescriptionPanel);
        this.m_functionDescriptionPanel = new VWFunctionDescriptionPanel();
        this.m_functionDescriptionPanel.init();
        this.m_descriptionPanel.add(VWResource.s_functionDescription, this.m_functionDescriptionPanel);
        this.m_stepResponseDescriptionPanel = new VWStepResponseDescriptionPanel();
        this.m_stepResponseDescriptionPanel.init();
        this.m_descriptionPanel.add(VWResource.s_stepResponseDescription, this.m_stepResponseDescriptionPanel);
        this.m_partnerLinkDescriptionPanel = new VWPartnerLinkDescriptionPanel(this.m_propertyData);
        this.m_partnerLinkDescriptionPanel.init();
        this.m_descriptionPanel.add(VWResource.s_partnerLinks, this.m_partnerLinkDescriptionPanel);
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_dataFieldDescription);
    }

    private void initItemTypeComboBox() {
        boolean bCreateWorkflow;
        boolean bWaitedForWorkflow = (this.m_itemTypes & 0x20) == 32;
        boolean bl = bCreateWorkflow = (this.m_itemTypes & 0x40) == 64;
        if (this.m_itemTypes != 0) {
            if ((this.m_itemTypes & 1) == 1) {
                this.m_itemTypeComboBox.addItem(VWResource.s_dataFields);
                if (bWaitedForWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_waitedForWorkflowDataFields);
                } else if (bCreateWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_createWorkflowDataFields);
                }
            }
            if ((this.m_itemTypes & 2) == 2) {
                this.m_itemTypeComboBox.addItem(VWResource.s_attachmentFields);
                if (bWaitedForWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_waitedForWorkflowAttachmentFields);
                } else if (bCreateWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_createWorkflowAttachmentFields);
                }
            }
            if ((this.m_itemTypes & 0x800) == 2048) {
                this.m_itemTypeComboBox.addItem(VWResource.s_guidFields);
                if (bWaitedForWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_waitedForWorkflowGuidFields);
                } else if (bCreateWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_createWorkflowGuidFields);
                }
            }
            if ((this.m_itemTypes & 4) == 4) {
                this.m_itemTypeComboBox.addItem(VWResource.s_workflowGroupsStr);
                if (bWaitedForWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_waitedForWorkflowWorkflowGroups);
                } else if (bCreateWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_createWorkflowWorkflowGroups);
                }
            }
            if ((this.m_itemTypes & 0x200) == 512) {
                this.m_itemTypeComboBox.addItem(VWResource.s_xmlDataFields);
                if (bWaitedForWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_waitedForWorkflowXMLDataFields);
                } else if (bCreateWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_createWorkflowXMLDataFields);
                }
            }
            if ((this.m_itemTypes & 0x80) == 128) {
                this.m_itemTypeComboBox.addItem(VWResource.s_systemFields);
                if (bWaitedForWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_waitedForWorkflowSystemFields);
                } else if (bCreateWorkflow) {
                    this.m_itemTypeComboBox.addItem(VWResource.s_createWorkflowSystemFields);
                }
            }
            if ((this.m_itemTypes & 0x400) == 1024) {
                this.m_itemTypeComboBox.addItem(VWResource.s_partnerLinks);
            }
            if ((this.m_itemTypes & 8) == 8) {
                this.m_itemTypeComboBox.addItem(VWResource.s_functionsStr);
            }
            if ((this.m_itemTypes & 0x10) == 16) {
                this.m_itemTypeComboBox.addItem(VWResource.s_stepResponses);
            }
            switch (this.m_defaultItem) {
                case 1: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_dataFields);
                    break;
                }
                case 2: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_attachmentFields);
                    break;
                }
                case 2048: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_guidFields);
                    break;
                }
                case 4: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_workflowGroupsStr);
                    break;
                }
                case 8: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_functionsStr);
                    break;
                }
                case 16: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_stepResponses);
                    break;
                }
                case 32: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_waitedForWorkflowSystemFields);
                    break;
                }
                case 64: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_createWorkflowSystemFields);
                    break;
                }
                case 128: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_systemFields);
                    break;
                }
                case 256: {
                    break;
                }
                case 512: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_xmlDataFields);
                    break;
                }
                case 1024: {
                    this.m_itemTypeComboBox.setSelectedItem(VWResource.s_partnerLinks);
                    break;
                }
                default: {
                    this.m_itemTypeComboBox.setSelectedIndex(0);
                }
            }
        }
    }

    private void performItemTypeAction() {
        String itemTypeString = this.m_itemTypeComboBox.getSelectedItem().toString();
        if (VWStringUtils.compare(itemTypeString, VWResource.s_dataFields) == 0) {
            this.showDataFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_waitedForWorkflowDataFields) == 0) {
            this.showWFWDataFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_createWorkflowDataFields) == 0) {
            this.showCreateWorkflowDataFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_attachmentFields) == 0) {
            this.showAttachmentFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_waitedForWorkflowAttachmentFields) == 0) {
            this.showWFWAttachmentFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_createWorkflowAttachmentFields) == 0) {
            this.showCreateWorkflowAttachmentFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_guidFields) == 0) {
            this.showGuidFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_waitedForWorkflowGuidFields) == 0) {
            this.showWFWGuidFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_createWorkflowGuidFields) == 0) {
            this.showCreateWorkflowGuidFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_workflowGroupsStr) == 0) {
            this.showWorkflowGroups();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_waitedForWorkflowWorkflowGroups) == 0) {
            this.showWFWWorkflowGroups();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_createWorkflowWorkflowGroups) == 0) {
            this.showCreateWorkflowWorkflowGroups();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_systemFields) == 0) {
            this.showSystemFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_waitedForWorkflowSystemFields) == 0) {
            this.showWFWSystemFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_createWorkflowSystemFields) == 0) {
            this.showCreateWorkflowSystemFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_functionsStr) == 0) {
            this.showFunctions();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_stepResponses) == 0) {
            this.showStepResponses();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_xmlDataFields) == 0) {
            this.showXMLDataFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_waitedForWorkflowXMLDataFields) == 0) {
            this.showWFWXMLDataFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_createWorkflowXMLDataFields) == 0) {
            this.showCreateWorkflowXMLDataFields();
        } else if (VWStringUtils.compare(itemTypeString, VWResource.s_partnerLinks) == 0) {
            this.showPartnerLinks();
        }
    }

    private void showDataFields() {
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_dataFieldDescription);
        this.m_currentDescriptionPanel = this.m_dataFieldDescriptionPanel;
        this.m_dataFieldDescriptionPanel.clean();
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        boolean bWaitedForWorkflow = (this.m_itemTypes & 0x20) == 32;
        try {
            int fieldDefCount;
            VWFieldDefinition[] fieldDefinitions = this.m_propertyData.getFields();
            if (fieldDefinitions != null && (fieldDefCount = fieldDefinitions.length) > 0) {
                for (int i = 0; i < fieldDefCount; ++i) {
                    VWFieldDefinition fieldDef = fieldDefinitions[i];
                    int type = fieldDef.getFieldType();
                    if (type == 32 || type == 512 || type == 64 || type == 128) continue;
                    String fieldName = fieldDef.getName();
                    if (this.m_orientation == 2 && bWaitedForWorkflow) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showWFWDataFields() {
        boolean isSystemFields = false;
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_dataFieldDescription);
        this.m_currentDescriptionPanel = this.m_dataFieldDescriptionPanel;
        this.m_dataFieldDescriptionPanel.clean();
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            int fieldDefCount;
            VWFieldDefinition[] fieldDefs;
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null && (fieldDefCount = fieldDefs.length) > 0) {
                for (int i = 0; i < fieldDefCount; ++i) {
                    String prefix;
                    int type;
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef == null || (type = fieldDef.getFieldType()) == 32 || type == 512 || type == 64 || type == 128) continue;
                    String fieldName = fieldDef.getName();
                    isSystemFields = fieldName.length() >= 2 ? (prefix = fieldName.substring(0, 2)).compareTo("F_") == 0 : false;
                    if (isSystemFields) continue;
                    if (this.m_orientation == 1) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showCreateWorkflowDataFields() {
        boolean isSystemFields = false;
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_dataFieldDescription);
        this.m_currentDescriptionPanel = this.m_dataFieldDescriptionPanel;
        this.m_dataFieldDescriptionPanel.clean();
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            VWFieldDefinition[] fieldDefs;
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null) {
                for (int i = 0; i < fieldDefs.length; ++i) {
                    String prefix;
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef == null || fieldDef.getFieldType() == 32 || fieldDef.getFieldType() == 512 || fieldDef.getFieldType() == 64 || fieldDef.getFieldType() == 128) continue;
                    String fieldName = fieldDef.getName();
                    isSystemFields = fieldName.length() >= 2 ? (prefix = fieldName.substring(0, 2)).compareTo("F_") == 0 : false;
                    if (isSystemFields) continue;
                    if (this.m_orientation == 2) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showAttachmentFields() {
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_attachmentFieldDescription);
        this.m_currentDescriptionPanel = this.m_attachmentFieldDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        boolean bWaitedForWorkflow = (this.m_itemTypes & 0x20) == 32;
        try {
            int fieldDefCount;
            VWFieldDefinition[] fieldDefinitions = this.m_propertyData.getFields();
            if (fieldDefinitions != null && (fieldDefCount = fieldDefinitions.length) > 0) {
                for (int i = 0; i < fieldDefCount; ++i) {
                    VWFieldDefinition fieldDef = fieldDefinitions[i];
                    if (fieldDef.getFieldType() != 32) continue;
                    String fieldName = fieldDef.getName();
                    if (bWaitedForWorkflow && this.m_orientation == 2) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showWFWAttachmentFields() {
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_attachmentFieldDescription);
        this.m_currentDescriptionPanel = this.m_attachmentFieldDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            int fieldDefCount;
            VWFieldDefinition[] fieldDefs;
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null && (fieldDefCount = fieldDefs.length) > 0) {
                for (int i = 0; i < fieldDefCount; ++i) {
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef == null || fieldDef.getFieldType() != 32) continue;
                    String fieldName = fieldDef.getName();
                    if (this.m_orientation == 1) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showCreateWorkflowAttachmentFields() {
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_attachmentFieldDescription);
        this.m_currentDescriptionPanel = this.m_attachmentFieldDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            VWFieldDefinition[] fieldDefs;
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null) {
                for (int i = 0; i < fieldDefs.length; ++i) {
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef == null || fieldDef.getFieldType() != 32) continue;
                    String fieldName = fieldDef.getName();
                    if (this.m_orientation == 2) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showGuidFields() {
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_guidFieldDescription);
        this.m_currentDescriptionPanel = this.m_guidFieldDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        boolean bWaitedForWorkflow = (this.m_itemTypes & 0x20) == 32;
        try {
            String[] systemGuids = new String[]{"F_CaseFolder", "F_CaseTask"};
            for (int i = 0; i < systemGuids.length; ++i) {
                VWFieldDefinition fieldDef = null;
                try {
                    fieldDef = this.m_propertyData instanceof VWAuthPropertyData ? ((VWAuthPropertyData)this.m_propertyData).getField(systemGuids[i]) : this.m_propertyData.getWorkflowDefinition().getField(systemGuids[i]);
                }
                catch (VWException ex) {
                    // empty catch block
                }
                if (fieldDef == null) continue;
                String fieldName = fieldDef.getName();
                if (bWaitedForWorkflow && this.m_orientation == 2) {
                    fieldName = "$" + fieldName;
                }
                this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                ++count;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showWFWGuidFields() {
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_guidFieldDescription);
        this.m_currentDescriptionPanel = this.m_guidFieldDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null) {
                int fieldDefCount;
                VWFieldDefinition[] fieldDefs;
                VWAuthPropertyData authPropertyData = null;
                if (this.m_propertyData instanceof VWAuthPropertyData) {
                    authPropertyData = (VWAuthPropertyData)this.m_propertyData;
                }
                if ((fieldDefs = wfSignature.getFieldDefinitions()) != null && (fieldDefCount = fieldDefs.length) > 0) {
                    for (int i = 0; i < fieldDefCount; ++i) {
                        VWFieldDefinition fieldDef = fieldDefs[i];
                        if (fieldDef == null || fieldDef.getFieldType() != 512) continue;
                        String fieldName = fieldDef.getName();
                        if (this.m_orientation == 1) {
                            fieldName = "$" + fieldName;
                        }
                        if (authPropertyData != null) {
                            authPropertyData.initializeCEObjectInfo(fieldDef);
                        }
                        this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                        ++count;
                    }
                    this.m_itemListModel.sort();
                    if (count > 0) {
                        this.m_itemList.setSelectedIndex(0);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showCreateWorkflowGuidFields() {
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_guidFieldDescription);
        this.m_currentDescriptionPanel = this.m_guidFieldDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null) {
                VWFieldDefinition[] fieldDefs;
                VWAuthPropertyData authPropertyData = null;
                if (this.m_propertyData instanceof VWAuthPropertyData) {
                    authPropertyData = (VWAuthPropertyData)this.m_propertyData;
                }
                if ((fieldDefs = wfSignature.getFieldDefinitions()) != null) {
                    for (int i = 0; i < fieldDefs.length; ++i) {
                        VWFieldDefinition fieldDef = fieldDefs[i];
                        if (fieldDef == null || fieldDef.getFieldType() != 512) continue;
                        String fieldName = fieldDef.getName();
                        if (this.m_orientation == 2) {
                            fieldName = "$" + fieldName;
                        }
                        if (authPropertyData != null) {
                            authPropertyData.initializeCEObjectInfo(fieldDef);
                        }
                        this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                        ++count;
                    }
                    this.m_itemListModel.sort();
                    if (count > 0) {
                        this.m_itemList.setSelectedIndex(0);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showWorkflowGroups() {
        boolean isSystemFields = false;
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_workflowGroupDescription);
        this.m_currentDescriptionPanel = this.m_workflowGroupDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        boolean bWaitedForWorkflow = (this.m_itemTypes & 0x20) == 32;
        try {
            int fieldDefCount;
            VWFieldDefinition[] fieldDefinitions = this.m_propertyData.getFields();
            if (fieldDefinitions != null && (fieldDefCount = fieldDefinitions.length) > 0) {
                for (int i = 0; i < fieldDefCount; ++i) {
                    String prefix;
                    VWFieldDefinition fieldDef = fieldDefinitions[i];
                    if (fieldDef.getFieldType() != 64) continue;
                    String fieldName = fieldDef.getName();
                    isSystemFields = fieldName.length() >= 2 ? (prefix = fieldName.substring(0, 2)).compareTo("F_") == 0 : false;
                    if (isSystemFields) continue;
                    if (bWaitedForWorkflow && this.m_orientation == 2) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showWFWWorkflowGroups() {
        boolean isSystemFields = false;
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_workflowGroupDescription);
        this.m_currentDescriptionPanel = this.m_workflowGroupDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            int fieldDefCount;
            VWFieldDefinition[] fieldDefs;
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null && (fieldDefCount = fieldDefs.length) > 0) {
                for (int i = 0; i < fieldDefCount; ++i) {
                    String prefix;
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef == null || fieldDef.getFieldType() != 64) continue;
                    String fieldName = fieldDef.getName();
                    isSystemFields = fieldName.length() >= 2 ? (prefix = fieldName.substring(0, 2)).compareTo("F_") == 0 : false;
                    if (isSystemFields) continue;
                    if (this.m_orientation == 1) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showCreateWorkflowWorkflowGroups() {
        boolean isSystemFields = false;
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_workflowGroupDescription);
        this.m_currentDescriptionPanel = this.m_workflowGroupDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            VWFieldDefinition[] fieldDefs;
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null) {
                for (int i = 0; i < fieldDefs.length; ++i) {
                    String prefix;
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef == null || fieldDef.getFieldType() != 64) continue;
                    String fieldName = fieldDef.getName();
                    isSystemFields = fieldName.length() >= 2 ? (prefix = fieldName.substring(0, 2)).compareTo("F_") == 0 : false;
                    if (isSystemFields) continue;
                    if (this.m_orientation == 2) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showSystemFields() {
        boolean isSystemFields = false;
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_dataFieldDescription);
        this.m_currentDescriptionPanel = this.m_dataFieldDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        boolean bWaitedForWorkflow = (this.m_itemTypes & 0x20) == 32;
        try {
            if (this.m_propertyData != null && this.m_propertyData.getVWSession() != null && this.m_propertyData.getBaseWorkflowDefinition() != null) {
                int fieldDefCount;
                VWFieldDefinition[] fieldDefs;
                VWWorkflowDefinition baseWflDef = this.m_propertyData.getBaseWorkflowDefinition();
                VWWorkflowSignature wfSignature = this.m_propertyData.getVWSession().fetchWorkflowSignature(baseWflDef.getName());
                if (wfSignature != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null && (fieldDefCount = fieldDefs.length) > 0) {
                    for (int i = 0; i < fieldDefCount; ++i) {
                        String prefix;
                        VWFieldDefinition fieldDef = fieldDefs[i];
                        if (fieldDef.getFieldType() == 32 || fieldDef.getFieldType() == 64) continue;
                        String fieldName = fieldDef.getName();
                        isSystemFields = fieldName.length() >= 2 ? (prefix = fieldName.substring(0, 2)).compareTo("F_") == 0 : false;
                        if (!isSystemFields) continue;
                        if (this.m_orientation == 2 && bWaitedForWorkflow) {
                            fieldName = "$" + fieldName;
                        }
                        this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                        ++count;
                    }
                    this.m_itemListModel.sort();
                    if (count > 0) {
                        this.m_itemList.setSelectedIndex(0);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showWFWSystemFields() {
        boolean isSystemFields = false;
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_dataFieldDescription);
        this.m_currentDescriptionPanel = this.m_dataFieldDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            int fieldDefCount;
            VWFieldDefinition[] fieldDefs;
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null && (fieldDefCount = fieldDefs.length) > 0) {
                for (int i = 0; i < fieldDefCount; ++i) {
                    String prefix;
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef == null || fieldDef.getFieldType() == 32 || fieldDef.getFieldType() == 64) continue;
                    String fieldName = fieldDef.getName();
                    isSystemFields = fieldName.length() >= 2 ? (prefix = fieldName.substring(0, 2)).compareTo("F_") == 0 : false;
                    if (!isSystemFields) continue;
                    if (this.m_orientation == 1) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showCreateWorkflowSystemFields() {
        boolean isSystemFields = false;
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_dataFieldDescription);
        this.m_currentDescriptionPanel = this.m_dataFieldDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            VWFieldDefinition[] fieldDefs;
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null) {
                for (int i = 0; i < fieldDefs.length; ++i) {
                    String prefix;
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef == null || fieldDef.getFieldType() == 32 || fieldDef.getFieldType() == 64) continue;
                    String fieldName = fieldDef.getName();
                    isSystemFields = fieldName.length() >= 2 ? (prefix = fieldName.substring(0, 2)).compareTo("F_") == 0 : false;
                    if (!isSystemFields) continue;
                    if (this.m_orientation == 2) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showFunctions() {
        int count;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_functionDescription);
        this.m_currentDescriptionPanel = this.m_functionDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        this.m_itemListModel.addElement(new VWExpressionItem(s_arrayFunctions.toString(), s_arrayFunctions));
        this.m_itemListModel.addElement(new VWExpressionItem(s_dataTypeConversionFunctions.toString(), s_dataTypeConversionFunctions));
        this.m_itemListModel.addElement(new VWExpressionItem(s_generalFunctions.toString(), s_generalFunctions));
        this.m_itemListModel.addElement(new VWExpressionItem(s_messageExpansionFunctions.toString(), s_messageExpansionFunctions));
        this.m_itemListModel.addElement(new VWExpressionItem(s_numericFunctions.toString(), s_numericFunctions));
        this.m_itemListModel.addElement(new VWExpressionItem(s_nullFunctions.toString(), s_nullFunctions));
        if ((this.m_itemTypes & 0x10) == 16) {
            this.m_itemListModel.addElement(new VWExpressionItem(s_stepResponseFunctions.toString(), s_stepResponseFunctions));
        }
        this.m_itemListModel.addElement(new VWExpressionItem(s_stringFunctions.toString(), s_stringFunctions));
        this.m_itemListModel.addElement(new VWExpressionItem(s_systemInterrogationFunctions.toString(), s_systemInterrogationFunctions));
        this.m_itemListModel.addElement(new VWExpressionItem(s_timeFunctions.toString(), s_timeFunctions));
        this.m_itemListModel.addElement(new VWExpressionItem(s_attachmentTemplateFunctions.toString(), s_attachmentTemplateFunctions));
        if (!this.m_propertyData.isProcessSimulation()) {
            this.m_itemListModel.addElement(new VWExpressionItem(s_xmlFunctions.toString(), s_xmlFunctions));
            this.m_itemListModel.addElement(new VWExpressionItem(s_xpathXsltFunctions.toString(), s_xpathXsltFunctions));
        }
        this.m_itemList.setSelectedIndex(0);
        if (this.m_defaultSubItem != null && this.m_defaultSubItem.length() > 0 && (count = this.m_itemListModel.getSize()) > 0) {
            for (int i = 0; i < count; ++i) {
                VWExpressionItem item = (VWExpressionItem)this.m_itemListModel.getElementAt(i);
                String functionName = item.toString();
                if (VWStringUtils.compare(functionName, this.m_defaultSubItem) != 0) continue;
                this.m_itemList.setSelectedIndex(i);
                break;
            }
        }
    }

    private void showStepResponses() {
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_stepResponseDescription);
        this.m_currentDescriptionPanel = this.m_stepResponseDescriptionPanel;
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            int responseCount;
            String[] responses;
            if (this.m_stepDefinition != null && (responses = this.m_stepDefinition.getResponses()) != null && (responseCount = responses.length) > 0) {
                for (int i = 0; i < responseCount; ++i) {
                    this.m_itemListModel.addElement(new VWExpressionItem(responses[i], responses[i]));
                }
                this.m_itemList.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showXMLDataFields() {
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_xmlDataFieldDescription);
        this.m_currentDescriptionPanel = this.m_xmlDataFieldDescriptionPanel;
        this.m_xmlDataFieldDescriptionPanel.clean();
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        boolean bWaitedForWorkflow = (this.m_itemTypes & 0x20) == 32;
        try {
            int fieldDefCount;
            VWFieldDefinition[] fieldDefinitions = this.m_propertyData.getFields();
            if (fieldDefinitions != null && (fieldDefCount = fieldDefinitions.length) > 0) {
                for (int i = 0; i < fieldDefCount; ++i) {
                    VWFieldDefinition fieldDef = fieldDefinitions[i];
                    if (fieldDef.getFieldType() != 128) continue;
                    String fieldName = fieldDef.getName();
                    if (this.m_orientation == 2 && bWaitedForWorkflow) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showWFWXMLDataFields() {
        boolean isSystemFields = false;
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_dataFieldDescription);
        this.m_currentDescriptionPanel = this.m_dataFieldDescriptionPanel;
        this.m_dataFieldDescriptionPanel.clean();
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            int fieldDefCount;
            VWFieldDefinition[] fieldDefs;
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null && (fieldDefCount = fieldDefs.length) > 0) {
                for (int i = 0; i < fieldDefCount; ++i) {
                    String prefix;
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef == null || fieldDef.getFieldType() != 128) continue;
                    String fieldName = fieldDef.getName();
                    isSystemFields = fieldName.length() >= 2 ? (prefix = fieldName.substring(0, 2)).compareTo("F_") == 0 : false;
                    if (isSystemFields) continue;
                    if (this.m_orientation == 1) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showCreateWorkflowXMLDataFields() {
        boolean isSystemFields = false;
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_dataFieldDescription);
        this.m_currentDescriptionPanel = this.m_dataFieldDescriptionPanel;
        this.m_dataFieldDescriptionPanel.clean();
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            VWFieldDefinition[] fieldDefs;
            VWWorkflowSignature wfSignature;
            if (this.m_workClassProxy != null && (wfSignature = this.m_workClassProxy.getWorkflowSignature()) != null && (fieldDefs = wfSignature.getFieldDefinitions()) != null) {
                for (int i = 0; i < fieldDefs.length; ++i) {
                    String prefix;
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef == null || fieldDef.getFieldType() != 128) continue;
                    String fieldName = fieldDef.getName();
                    isSystemFields = fieldName.length() >= 2 ? (prefix = fieldName.substring(0, 2)).compareTo("F_") == 0 : false;
                    if (isSystemFields) continue;
                    if (this.m_orientation == 2) {
                        fieldName = "$" + fieldName;
                    }
                    this.m_itemListModel.addElement(new VWExpressionItem(fieldName, fieldDef));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void showPartnerLinks() {
        int count = 0;
        this.m_cardLayout.show(this.m_descriptionPanel, VWResource.s_partnerLinks);
        this.m_currentDescriptionPanel = this.m_partnerLinkDescriptionPanel;
        this.m_partnerLinkDescriptionPanel.clean();
        this.m_itemList.removeListSelectionListener(this);
        this.m_itemListModel.removeAllElements();
        this.m_itemList.addListSelectionListener(this);
        try {
            int partnerLinkCount;
            VWPartnerLinkDefinition[] partnerLinks;
            if (this.m_propertyData.getWorkflowDefinition() != null && (partnerLinks = this.m_propertyData.getWorkflowDefinition().getPartnerLinks()) != null && (partnerLinkCount = partnerLinks.length) > 0) {
                for (int i = 0; i < partnerLinkCount; ++i) {
                    VWPartnerLinkDefinition partnerLink = partnerLinks[i];
                    if (partnerLink.getPartnerEndPoint() == null) continue;
                    this.m_itemListModel.addElement(new VWExpressionItem(partnerLink.getName(), partnerLink));
                    ++count;
                }
                this.m_itemListModel.sort();
                if (count > 0) {
                    this.m_itemList.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

